package ws.afterglo.audioPod;

import java.util.Date;

/**
 * @author muti
 * modified by philippe &  northernlad
 *
 */
public class TrackItem implements Comparable {
    private long	trackid;
    private long	length; //in microseconds
    private long	tracknum;
    private long	year;
    private long  compilation;
    private String	artist;
    private String	album;
    private String	track;
    private String  mbid;
    private long	playcount;
    private long	lastplayed;
    private String 	source;
    private String  trackPath;
    private String  format;
    
    /**
     * Default constructor 
     */
    public TrackItem() {
        this.trackid = 0;
        this.length = 0;
        this.tracknum = 0;
        this.year = 0;
        this.compilation = 0;
        this.artist = "";
        this.album = "";
        this.track = "";
        this.playcount = 0;
        this.lastplayed = 0;
        this.source="";
        this.trackPath="";
        this.format="";
    }
    
    /**
     * @return Returns the album.
     */
    public String getAlbum() {
        return album;
    }
    /**
     * @param album The album to set.
     */
    public void setAlbum(String album) {
        this.album = album;
    }
    
    /**
     * @return Returns the source.
     */
    public String getSource() {
        return source;
    }
    /**
     * @param source The source to set.
     */
    public void setSource(String source) {
        this.source = source;
    }
    
    /**
     * @return Returns the artist.
     */
    public String getArtist() {
        return artist;
    }
    /**
     * @param artist The artist to set.
     */
    public void setArtist(String artist) {
        this.artist = artist;
    }
    
    /**
     * @return Returns the lastplayed.
     */
    public long getLastplayed() {
        return lastplayed;
    }
    /**
     * @param lastplayed UNIX timestamp, in seconds.
     */
    public void setLastplayed(long lastplayed) {
        this.lastplayed = lastplayed;
    }
    
    /**
     * @return Returns the length.
     */
    public long getLength() {
        return length;
    }
    /**
     * @param length The length to set.
     */
    public void setLength(long length) {
        this.length = length;
    }
    
    public long getTrackNum() {
        return tracknum;
    }

    public void setTrackNum(long tracknum) {
        this.tracknum = tracknum;
    }
    
    public long getYear() {
        return year;
    }

    public void setYear(long year) {
        this.year = year;
    }

    public long getIsCompilation() {
        return compilation;
    }

    public void setIsCompilation(long compilation) {
        this.compilation = compilation;
    }
    /**
     * @return Returns the playcount.
     */
    public long getPlaycount() {
        return playcount;
    }
    /**
     * @param playcount The playcount to set.
     */
    public void setPlaycount(long playcount) {
        this.playcount = playcount;
    }
    
    /**
     * @return Returns the track.
     */
    public String getTrack() {
        return track;
    }
    /**
     * @param track The track to set.
     */
    public void setTrack(String track) {
        this.track = track;
    }
    
    /**
     * @return Returns the trackid.
     */
    public long getTrackid() {
        return trackid;
    }
    /**
     * @param trackid The trackid to set.
     */
    public void setTrackid(long trackid) {
        this.trackid = trackid;
    }
    
    
    public int compareTo(Object track) {
        TrackItem temptrack = (TrackItem)track;
        
        if(this.lastplayed < temptrack.getLastplayed()) {
            return -1;
        } else if(this.lastplayed > temptrack.getLastplayed()) {
            return 1;
        }
        return 0;
    }
    
    public void setMBID(String m)
    {
        this.mbid = m;
    }
    
    public String getMBID()
    {
        if (this.mbid == null)
            return new String("");
        else
            return this.mbid;
    }
    
    public void setTrackPath(String m)
    {
        this.trackPath = m;
    }
    
    public String getTrackPath()
    {
    	return this.trackPath;
    }
    
    public void setFormat(String m)
    {
        this.format = m;
    }
    
    public String getFormat()
    {
    	return this.format;
    }
    
    public String toString() {
        String tempstring;
        
        tempstring  = "Track ID: " + trackid + "\n";
        tempstring += "Length: " + length + "\n";
        tempstring += "Artist: " + artist + "\n";
        tempstring += "Album: " + album + "\n";
        tempstring += "Track: " + track + "\n";
        tempstring += "Play Count: " + playcount + "\n";
        tempstring += "Last Played: " + new Date(lastplayed * 1000) + "\n";
        
        return tempstring;
    }
}
